(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21421,        744]*)
(*NotebookOutlinePosition[     22299,        774]*)
(*  CellTagsIndexPosition[     22255,        770]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Repeated Roots-Example 2"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["The coefficient matrix A"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["\<\
(B={{1,0,0,0,0,0},{2,1,0,0,0,0},{-1,1,1,0,0,0},
\t{2,0,1,1,0,0},{-2,2,1,0,1,0},{0,1,0,1,-2,1}})//MatrixForm\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "0", "0", "0", "0", "0"},
            {"2", "1", "0", "0", "0", "0"},
            {\(-1\), "1", "1", "0", "0", "0"},
            {"2", "0", "1", "1", "0", "0"},
            {\(-2\), "2", "1", "0", "1", "0"},
            {"0", "1", "0", "1", \(-2\), "1"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["(Sym=B.Transpose[B])//MatrixForm", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "2", \(-1\), "2", \(-2\), "0"},
            {"2", "5", \(-1\), "4", \(-2\), "1"},
            {\(-1\), \(-1\), "3", \(-1\), "5", "1"},
            {"2", "4", \(-1\), "6", \(-3\), "1"},
            {\(-2\), \(-2\), "5", \(-3\), "10", "0"},
            {"0", "1", "1", "1", "0", "7"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Det[Sym]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(1\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
(A1={{2, 1, 0, 0, 0, 0}, {0, 2, 1, 0, 0, 0}, 
\t{0, 0, 2, 0, 0, 0}, {0, 0, 0, 2, 0, 0}, 
  \t{0, 0, 0, 0, 2, 1}, {0, 0, 0, 0, 0, 2}})//MatrixForm\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"2", "1", "0", "0", "0", "0"},
            {"0", "2", "1", "0", "0", "0"},
            {"0", "0", "2", "0", "0", "0"},
            {"0", "0", "0", "2", "0", "0"},
            {"0", "0", "0", "0", "2", "1"},
            {"0", "0", "0", "0", "0", "2"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell["\<\
Use this matrix: (It is similar to the matrix A1, which is in \
Jordan form.)\
\>", "Subsubsection"],

Cell[CellGroupData[{

Cell["(A=Inverse[Sym].A1.Sym)//MatrixForm", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"501", "1179", \(-383\), "962", \(-759\), "355"},
            {\(-150\), \(-352\), "116", \(-289\), "230", \(-108\)},
            {\(-19\), \(-46\), "16", \(-38\), "31", \(-26\)},
            {\(-41\), \(-97\), "31", \(-77\), "61", \(-27\)},
            {"67", "159", \(-51\), "130", \(-101\), "55"},
            {"30", "71", \(-23\), "58", \(-46\), "25"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Size=Length[A]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(6\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A-r*I"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["(mat[r_]=A-r*IdentityMatrix[Length[A]])//MatrixForm", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(501 - r\), "1179", \(-383\), "962", \(-759\), "355"},
            {\(-150\), \(\(-352\) - r\), "116", \(-289\), "230", \(-108\)},
            {\(-19\), \(-46\), \(16 - r\), \(-38\), "31", \(-26\)},
            {\(-41\), \(-97\), "31", \(\(-77\) - r\), "61", \(-27\)},
            {"67", "159", \(-51\), "130", \(\(-101\) - r\), "55"},
            {"30", "71", \(-23\), "58", \(-46\), \(25 - r\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Characteristic Polynomial"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["CharPoly=Factor[Det[mat[r]]]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\((\(-2\) + r)\)\^6\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Characteristic Roots"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["roots=Sort[r/.Solve[CharPoly==0,r]]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(roots\)\" is similar to \
existing symbol \"\!\(Roots\)\"."\)], "Message"],

Cell[BoxData[
    \({2, 2, 2, 2, 2, 2}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["RootMultiplicities=RunEncode[roots]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{2, 6}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["{thisRoot,thisMultiplicity}=First[RootMultiplicities]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({2, 6}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Search for Characteristic Vectors"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["(MPwr=M=mat[thisRoot])//MatrixForm", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"499", "1179", \(-383\), "962", \(-759\), "355"},
            {\(-150\), \(-354\), "116", \(-289\), "230", \(-108\)},
            {\(-19\), \(-46\), "14", \(-38\), "31", \(-26\)},
            {\(-41\), \(-97\), "31", \(-79\), "61", \(-27\)},
            {"67", "159", \(-51\), "130", \(-103\), "55"},
            {"30", "71", \(-23\), "58", \(-46\), "23"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["NS=NullSpace[M]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{44, \(-16\), 9, 0, 0, 1}, {\(-11\), 4, \(-4\), 0, 1, 0}, {4, \(-3\), 
        1, 2, 0, 0}}\)], "Output"]
}, Closed]],

Cell[TextData[
"We have found some of the characteristic vectors.  Check the deficiency of \
the matrix."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Deficiency=thisMultiplicity-Length[NS]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(3\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Search for More Characteristic Vectors"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["AllKs=Table[k[i],{i,Size*(Deficiency+1)}];", "Input",
  AspectRatioFixed->False],

Cell["K[i_]:=Table[k[j],{j,i*Size+1,(i+1)Size}]", "Input",
  AspectRatioFixed->False],

Cell["\<\
sys=Join[{M.K[Deficiency]==0*K[Deficiency]},
\t\tTable[M.K[Deficiency-i]==K[Deficiency-i+1],
\t\t\t{i,Deficiency}]];\
\>", "Input",
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["KSolve=Solve[sys,AllKs]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(General::"spell" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(KSolve\)\" is similar \
to existing symbols \!\({DSolve, NSolve, Solve}\)."\)], "Message"],

Cell[BoxData[
    \(Solve::"svars" \(\(:\)\(\ \)\) 
      "Equations may not give solutions for all \"solve\" variables."\)], \
"Message"],

Cell[BoxData[
    \({{k[1] \[Rule] 
          2\ k[4] - 11\ k[5] + 
            44\ k[6] - \(95\ k[11]\)\/7 + \(213\ k[12]\)\/7 + \(18\ \
k[18]\)\/91, 
        k[2] \[Rule] \(-\(\(3\ k[4]\)\/2\)\) + 4\ k[5] - 
            16\ k[6] + \(67\ k[11]\)\/14 - \(75\ k[12]\)\/7 - \(11\ \
k[18]\)\/182, 
        k[3] \[Rule] 
          k[4]\/2 - 4\ k[5] + 
            9\ k[6] - \(41\ k[11]\)\/14 + \(46\ k[12]\)\/7 + k[18]\/14, 
        k[7] \[Rule] \(-\(\(57\ k[
                      11]\)\/7\)\) + \(244\ k[12]\)\/7 + \(8\ k[18]\)\/91, 
        k[8] \[Rule] \(13\ k[11]\)\/7 - \(64\ k[12]\)\/7 + k[18]\/91, 
        k[9] \[Rule] \(-\(\(23\ k[
                      11]\)\/7\)\) + \(47\ k[12]\)\/7 + \(2\ k[18]\)\/91, 
        k[10] \[Rule] \(10\ k[11]\)\/7 - \(32\ k[12]\)\/7 - \(3\ k[18]\)\/91, 
        k[13] \[Rule] \(217\ k[18]\)\/13, k[14] \[Rule] \(-5\)\ k[18], 
        k[15] \[Rule] \(-\(\(8\ k[18]\)\/13\)\), 
        k[16] \[Rule] \(-\(\(18\ k[18]\)\/13\)\), 
        k[17] \[Rule] \(29\ k[18]\)\/13, k[19] \[Rule] 0, k[20] \[Rule] 0, 
        k[21] \[Rule] 0, k[22] \[Rule] 0, k[23] \[Rule] 0, 
        k[24] \[Rule] 0}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Free Variables"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["\<\
FreeKs=Complement[AllKs,
\tTranspose[KSolve]/.List[Rule[p_,q___]]->p]\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({k[4], k[5], k[6], k[11], k[12], k[18]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Do we have all of the solutions?"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["Length[FreeKs]==thisMultiplicity", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The constant vectors"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Compute them"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell["\<\
Clear[KS]
KS[i_]:=K[i]/.KSolve[[1]]\
\>", "Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Display them individually"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["KS[0]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({2\ k[4] - 11\ k[5] + 
        44\ k[6] - \(95\ k[11]\)\/7 + \(213\ k[12]\)\/7 + \(18\ k[18]\)\/91, \
\(-\(\(3\ k[4]\)\/2\)\) + 4\ k[5] - 
        16\ k[6] + \(67\ k[11]\)\/14 - \(75\ k[12]\)\/7 - \(11\ k[18]\)\/182, 
      k[4]\/2 - 4\ k[5] + 9\ k[6] - \(41\ k[11]\)\/14 + \(46\ k[12]\)\/7 + 
        k[18]\/14, k[4], k[5], k[6]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["KS[1]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\(-\(\(57\ k[
                  11]\)\/7\)\) + \(244\ k[12]\)\/7 + \(8\ k[18]\)\/91, \(13\ \
k[11]\)\/7 - \(64\ k[12]\)\/7 + 
        k[18]\/91, \(-\(\(23\ k[
                  11]\)\/7\)\) + \(47\ k[12]\)\/7 + \(2\ k[18]\)\/91, \(10\ \
k[11]\)\/7 - \(32\ k[12]\)\/7 - \(3\ k[18]\)\/91, k[11], k[12]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["KS[2]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\(217\ k[18]\)\/13, \(-5\)\ k[
          18], \(-\(\(8\ k[18]\)\/13\)\), \(-\(\(18\ k[
                18]\)\/13\)\), \(29\ k[18]\)\/13, k[18]}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["KS[3]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({0, 0, 0, 0, 0, 0}\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Null out all other variables"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["\<\
Sub0=Map[Apply[Rule,#]&,
\tTranspose[{AllKs,0*AllKs}]]\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({k[1] \[Rule] 0, k[2] \[Rule] 0, k[3] \[Rule] 0, k[4] \[Rule] 0, 
      k[5] \[Rule] 0, k[6] \[Rule] 0, k[7] \[Rule] 0, k[8] \[Rule] 0, 
      k[9] \[Rule] 0, k[10] \[Rule] 0, k[11] \[Rule] 0, k[12] \[Rule] 0, 
      k[13] \[Rule] 0, k[14] \[Rule] 0, k[15] \[Rule] 0, k[16] \[Rule] 0, 
      k[17] \[Rule] 0, k[18] \[Rule] 0, k[19] \[Rule] 0, k[20] \[Rule] 0, 
      k[21] \[Rule] 0, k[22] \[Rule] 0, k[23] \[Rule] 0, 
      k[24] \[Rule] 0}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(Clear[p, x]\)], "Input"],

Cell[BoxData[
    \(\(SolutionForm = \[Sum]\+\(m = 0\)\%2\( KS[m]\ x\^m\)\/\(m!\);\)\)], \
"Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["We can look at the individual solutions manually"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["\<\
y1[x_]=(SolutionForm)Exp[thisRoot*x]/.
\t\tk[4]->1/.Sub0\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({2\ \[ExponentialE]\^\(2\ x\), \(-\(\(3\ \[ExponentialE]\^\(2\ x\)\)\/2\
\)\), \[ExponentialE]\^\(2\ x\)\/2, \[ExponentialE]\^\(2\ x\), 0, 
      0}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
y2[x_]=(SolutionForm)Exp[thisRoot*x]/.
\t\tk[5]->1/.Sub0\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\(-11\)\ \[ExponentialE]\^\(2\ x\), 
      4\ \[ExponentialE]\^\(2\ x\), \(-4\)\ \[ExponentialE]\^\(2\ x\), 
      0, \[ExponentialE]\^\(2\ x\), 0}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
y3[x_]=(SolutionForm)Exp[thisRoot*x]/.
\t\tk[6]->1/.Sub0\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({44\ \[ExponentialE]\^\(2\ x\), \(-16\)\ \[ExponentialE]\^\(2\ x\), 
      9\ \[ExponentialE]\^\(2\ x\), 0, 
      0, \[ExponentialE]\^\(2\ x\)}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
y4[x_]=(SolutionForm)Exp[thisRoot*x]/.
\t\tk[11]->1/.Sub0\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(2\ x\)\ \((\(-\(95\/7\)\) - \(57\ x\)\/7)\), \
\[ExponentialE]\^\(2\ x\)\ \((67\/14 + \(13\ x\)\/7)\), \[ExponentialE]\^\(2\ \
x\)\ \((\(-\(41\/14\)\) - \(23\ x\)\/7)\), 
      10\/7\ \[ExponentialE]\^\(2\ x\)\ x, \[ExponentialE]\^\(2\ x\)\ x, 
      0}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
y5[x_]=(SolutionForm)Exp[thisRoot*x]/.
\t\tk[12]->1/.Sub0\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(2\ x\)\ \((213\/7 + \(244\ x\)\/7)\), \
\[ExponentialE]\^\(2\ x\)\ \((\(-\(75\/7\)\) - \(64\ x\)\/7)\), \
\[ExponentialE]\^\(2\ x\)\ \((46\/7 + \(47\ x\)\/7)\), \(-\(32\/7\)\)\ \
\[ExponentialE]\^\(2\ x\)\ x, 0, \[ExponentialE]\^\(2\ x\)\ x}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
y6[x_]=(SolutionForm)Exp[thisRoot*x]/.
\t\tk[18]->1/.Sub0\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(2\ x\)\ \((18\/91 + \(8\ x\)\/91 + \(217\ \
x\^2\)\/26)\), \[ExponentialE]\^\(2\ x\)\ \((\(-\(11\/182\)\) + 
            x\/91 - \(5\ x\^2\)\/2)\), \[ExponentialE]\^\(2\ x\)\ \((1\/14 + \
\(2\ x\)\/91 - \(4\ x\^2\)\/13)\), \[ExponentialE]\^\(2\ x\)\ \((\(-\(\(3\ \
x\)\/91\)\) - \(9\ x\^2\)\/13)\), 29\/26\ \[ExponentialE]\^\(2\ x\)\ x\^2, 
      1\/2\ \[ExponentialE]\^\(2\ x\)\ x\^2}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["We can Produce the solutions Automatically"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["\<\
WT[x_]=Table[((SolutionForm)Exp[thisRoot*x]/.
\t\tFreeKs[[j]]->1/.Sub0),{j,thisMultiplicity}]\
\>", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{2\ \[ExponentialE]\^\(2\ x\), \(-\(\(3\ \[ExponentialE]\^\(2\ \
x\)\)\/2\)\), \[ExponentialE]\^\(2\ x\)\/2, \[ExponentialE]\^\(2\ x\), 0, 
        0}, {\(-11\)\ \[ExponentialE]\^\(2\ x\), 
        4\ \[ExponentialE]\^\(2\ x\), \(-4\)\ \[ExponentialE]\^\(2\ x\), 
        0, \[ExponentialE]\^\(2\ x\), 
        0}, {44\ \[ExponentialE]\^\(2\ x\), \(-16\)\ \[ExponentialE]\^\(2\ \
x\), 9\ \[ExponentialE]\^\(2\ x\), 0, 
        0, \[ExponentialE]\^\(2\ x\)}, {\[ExponentialE]\^\(2\ x\)\ \((\(-\(95\
\/7\)\) - \(57\ x\)\/7)\), \[ExponentialE]\^\(2\ x\)\ \((67\/14 + \(13\ \
x\)\/7)\), \[ExponentialE]\^\(2\ x\)\ \((\(-\(41\/14\)\) - \(23\ x\)\/7)\), 
        10\/7\ \[ExponentialE]\^\(2\ x\)\ x, \[ExponentialE]\^\(2\ x\)\ x, 
        0}, {\[ExponentialE]\^\(2\ x\)\ \((213\/7 + \(244\ x\)\/7)\), \
\[ExponentialE]\^\(2\ x\)\ \((\(-\(75\/7\)\) - \(64\ x\)\/7)\), \
\[ExponentialE]\^\(2\ x\)\ \((46\/7 + \(47\ x\)\/7)\), \(-\(32\/7\)\)\ \
\[ExponentialE]\^\(2\ x\)\ x, 
        0, \[ExponentialE]\^\(2\ x\)\ x}, {\[ExponentialE]\^\(2\ x\)\ \
\((18\/91 + \(8\ x\)\/91 + \(217\ x\^2\)\/26)\), \[ExponentialE]\^\(2\ x\)\ \
\((\(-\(11\/182\)\) + 
              x\/91 - \(5\ x\^2\)\/2)\), \[ExponentialE]\^\(2\ x\)\ \((1\/14 \
+ \(2\ x\)\/91 - \(4\ x\^2\)\/13)\), \[ExponentialE]\^\(2\ x\)\ \((\(-\(\(3\ \
x\)\/91\)\) - \(9\ x\^2\)\/13)\), 29\/26\ \[ExponentialE]\^\(2\ x\)\ x\^2, 
        1\/2\ \[ExponentialE]\^\(2\ x\)\ x\^2}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Wronskian Matrix"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["(W[x_]=Transpose[WT[x]])//MatrixForm", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(2\ \[ExponentialE]\^\(2\ x\)\), \(\(-11\)\ \
\[ExponentialE]\^\(2\ x\)\), \(44\ \[ExponentialE]\^\(2\ x\)\), \(\
\[ExponentialE]\^\(2\ x\)\ \((\(-\(95\/7\)\) - \(57\ x\)\/7)\)\), \(\
\[ExponentialE]\^\(2\ x\)\ \((213\/7 + \(244\ x\)\/7)\)\), \
\(\[ExponentialE]\^\(2\ x\)\ \((18\/91 + \(8\ x\)\/91 + \(217\ \
x\^2\)\/26)\)\)},
            {\(-\(\(3\ \[ExponentialE]\^\(2\ x\)\)\/2\)\), \(4\ \
\[ExponentialE]\^\(2\ x\)\), \(\(-16\)\ \[ExponentialE]\^\(2\ x\)\), \(\
\[ExponentialE]\^\(2\ x\)\ \((67\/14 + \(13\ x\)\/7)\)\), \(\[ExponentialE]\^\
\(2\ x\)\ \((\(-\(75\/7\)\) - \(64\ x\)\/7)\)\), \(\[ExponentialE]\^\(2\ x\)\ \
\((\(-\(11\/182\)\) + x\/91 - \(5\ x\^2\)\/2)\)\)},
            {\(\[ExponentialE]\^\(2\ x\)\/2\), \(\(-4\)\ \[ExponentialE]\^\(2\
\ x\)\), \(9\ \[ExponentialE]\^\(2\ x\)\), \(\[ExponentialE]\^\(2\ x\)\ \
\((\(-\(41\/14\)\) - \(23\ x\)\/7)\)\), \(\[ExponentialE]\^\(2\ x\)\ \((46\/7 \
+ \(47\ x\)\/7)\)\), \(\[ExponentialE]\^\(2\ x\)\ \((1\/14 + \(2\ x\)\/91 - \
\(4\ x\^2\)\/13)\)\)},
            {\(\[ExponentialE]\^\(2\ x\)\), "0", 
              "0", \(10\/7\ \[ExponentialE]\^\(2\ x\)\ x\), \(\(-\(32\/7\)\)\ \
\[ExponentialE]\^\(2\ x\)\ x\), \(\[ExponentialE]\^\(2\ x\)\ \((\(-\(\(3\ x\)\
\/91\)\) - \(9\ x\^2\)\/13)\)\)},
            {"0", \(\[ExponentialE]\^\(2\ x\)\), 
              "0", \(\[ExponentialE]\^\(2\ x\)\ x\), 
              "0", \(29\/26\ \[ExponentialE]\^\(2\ x\)\ x\^2\)},
            {"0", "0", \(\[ExponentialE]\^\(2\ x\)\), 
              "0", \(\[ExponentialE]\^\(2\ x\)\ x\), \(1\/2\ \
\[ExponentialE]\^\(2\ x\)\ x\^2\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["It Satisfies the differential equation"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["Simplify[W'[x]==A.W[x]]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["It is Fundamental"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["Det[W[x]]", "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\[ExponentialE]\^\(12\ x\)\/182\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Implementation"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell["\<\
Attributes[times]={Flat};
times[{a_,m_},{a_,n_}]:=times[{a,m+n}]
RunEncode[x_List]:=List@@times@@({#,1}&/@ x)\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->False],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(times\)\" is similar to \
existing symbol \"\!\(Times\)\"."\)], "Message"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{633, 538},
WindowMargins->{{20, Automatic}, {Automatic, 13}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, -1}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 102, 2, 65, "Subtitle",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[1903, 59, 101, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2029, 65, 159, 4, 72, "Input"],
Cell[2191, 71, 452, 11, 117, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[2680, 87, 76, 1, 27, "Input"],
Cell[2759, 90, 480, 11, 117, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3276, 106, 52, 1, 27, "Input"],
Cell[3331, 109, 35, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[3403, 115, 197, 5, 72, "Input"],
Cell[3603, 122, 443, 11, 117, "Output"]
}, Closed]],
Cell[4061, 136, 110, 3, 42, "Subsubsection"],

Cell[CellGroupData[{
Cell[4196, 143, 79, 1, 27, "Input"],
Cell[4278, 146, 549, 11, 117, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4864, 162, 58, 1, 27, "Input"],
Cell[4925, 165, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5009, 172, 83, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5117, 178, 95, 1, 27, "Input"],
Cell[5215, 181, 591, 11, 117, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5855, 198, 107, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5987, 204, 72, 1, 27, "Input"],
Cell[6062, 207, 53, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6164, 214, 102, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6291, 220, 79, 1, 27, "Input"],
Cell[6373, 223, 183, 3, 35, "Message"],
Cell[6559, 228, 52, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6648, 234, 79, 1, 27, "Input"],
Cell[6730, 237, 42, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6809, 243, 97, 1, 27, "Input"],
Cell[6909, 246, 40, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6998, 253, 110, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7133, 259, 78, 1, 27, "Input"],
Cell[7214, 262, 549, 11, 117, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7800, 278, 59, 1, 27, "Input"],
Cell[7862, 281, 126, 2, 27, "Output"]
}, Closed]],
Cell[8003, 286, 163, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8191, 294, 82, 1, 27, "Input"],
Cell[8276, 297, 35, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8360, 304, 115, 2, 36, "Section",
  Evaluatable->False],
Cell[8478, 308, 86, 1, 27, "Input"],
Cell[8567, 311, 85, 1, 27, "Input"],
Cell[8655, 314, 168, 5, 57, "Input"],

Cell[CellGroupData[{
Cell[8848, 323, 67, 1, 27, "Input"],
Cell[8918, 326, 198, 3, 35, "Message"],
Cell[9119, 331, 138, 3, 21, "Message"],
Cell[9260, 336, 1140, 22, 271, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10449, 364, 96, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10570, 370, 121, 4, 42, "Input"],
Cell[10694, 376, 73, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10816, 383, 110, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10951, 389, 76, 1, 27, "Input"],
Cell[11030, 392, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11117, 399, 98, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11240, 405, 93, 2, 46, "Subsection",
  Evaluatable->False],
Cell[11336, 409, 87, 4, 42, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[11460, 418, 106, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11591, 424, 49, 1, 27, "Input"],
Cell[11643, 427, 364, 6, 110, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[12044, 438, 49, 1, 27, "Input"],
Cell[12096, 441, 335, 6, 76, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[12468, 452, 49, 1, 27, "Input"],
Cell[12520, 455, 178, 3, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[12735, 463, 49, 1, 27, "Input"],
Cell[12787, 466, 52, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12900, 474, 106, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13031, 480, 106, 4, 42, "Input"],
Cell[13140, 486, 475, 7, 75, "Output"]
}, Closed]],
Cell[13630, 496, 44, 1, 27, "Input"],
Cell[13677, 499, 126, 3, 51, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[13840, 507, 126, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13991, 513, 108, 4, 42, "Input"],
Cell[14102, 519, 182, 3, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[14321, 527, 108, 4, 42, "Input"],
Cell[14432, 533, 182, 3, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[14651, 541, 108, 4, 42, "Input"],
Cell[14762, 547, 178, 3, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[14977, 555, 109, 4, 42, "Input"],
Cell[15089, 561, 307, 5, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[15433, 571, 109, 4, 42, "Input"],
Cell[15545, 577, 295, 4, 42, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[15877, 586, 109, 4, 42, "Input"],
Cell[15989, 592, 439, 6, 83, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[16477, 604, 120, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16622, 610, 145, 4, 42, "Input"],
Cell[16770, 616, 1456, 22, 206, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18275, 644, 98, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[18398, 650, 80, 1, 27, "Input"],
Cell[18481, 653, 1771, 31, 183, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[20301, 690, 116, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[20442, 696, 67, 1, 27, "Input"],
Cell[20512, 699, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[20599, 706, 95, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[20719, 712, 53, 1, 27, "Input"],
Cell[20775, 715, 65, 1, 45, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[20889, 722, 92, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21006, 728, 189, 6, 70, "Input",
  InitializationCell->True],
Cell[21198, 736, 183, 3, 70, "Message"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

ationCell->True]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

 "Input"],
Cell[8212, 306, 105, 6, 70, "Output",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8358, 314, 115, 2, 70, "Section",
  Evaluatable->False],
Cell[8476, 318, 96, 1, 70, "Input"],
Cell[8575, 321, 95, 1, 70, "Input"],
Cell[8673, 324, 178, 4, 70, "Input"],

Cell[CellGroupData[{
Cell[8874, 330, 77, 1, 70, "Input"],
Cell[8954, 333, 2304, 69, 70, "Output",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11299, 404, 96, 2, 70, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11418, 408, 128, 3, 70, "Input"],
Cell[11549, 413, 182, 7, 70, "Output",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11772, 422, 110, 2, 70, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11905, 426, 86, 1, 70, "Input"],
Cell[11994, 429, 111, 6, 70, "Output",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12146, 437, 98, 2, 70, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12267, 441, 93, 2, 70, "Subsection",
  Evaluatable->False],
Cell[12363, 445, 90, 1, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[12485, 448, 106, 2, 70, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12614, 452, 59, 1, 70, "Input"],
Cell[12676, 455, 928, 28, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[13636, 485, 59, 1, 70, "Input"],
Cell[13698, 488, 703, 24, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[14433, 514, 59, 1, 70, "Input"],
Cell[14495, 517, 351, 12, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[14878, 531, 59, 1, 70, "Input"],
Cell[14940, 534, 140, 7, 70, "Output",
  Evaluatable->False]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15130, 543, 106, 2, 70, "Section",
  Evaluatable->False],
Cell[15239, 547, 111, 2, 70, "Input"],
Cell[15353, 551, 102, 1, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[15487, 554, 126, 2, 70, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15636, 558, 112, 2, 70, "Input"],
Cell[15751, 562, 266, 11, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[16049, 575, 112, 2, 70, "Input"],
Cell[16164, 579, 231, 9, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[16427, 590, 112, 2, 70, "Input"],
Cell[16542, 594, 234, 9, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[16808, 605, 113, 2, 70, "Input"],
Cell[16924, 609, 487, 16, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[17443, 627, 113, 2, 70, "Input"],
Cell[17559, 631, 487, 16, 70, "Output",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[18078, 649, 113, 2, 70, "Input"],
Cell[18194, 653, 782, 24, 70, "Output",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[19017, 679, 120, 2, 70, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[19160, 683, 151, 3, 70, "Input"],
Cell[19314, 688, 2080, 63, 70, "Output",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21435, 753, 98, 2, 70, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[21556, 757, 76, 1, 70, "Input"],
Cell[21635, 760, 2278, 69, 70, "Output",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[23954, 831, 116, 2, 70, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[24093, 835, 76, 1, 70, "Input"],
Cell[24172, 838, 360, 13, 70, "Output",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[24573, 853, 95, 2, 70, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[24691, 857, 63, 1, 70, "Input"],
Cell[24757, 860, 133, 9, 70, "Output",
  Evaluatable->False]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[24931, 871, 92, 2, 70, "Section",
  Evaluatable->False],
Cell[25026, 875, 196, 4, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
